/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.portal.service.impl;

import com.tp_link.eap.domain.cloud.CloudUser;
import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eap.Client;
import com.tp_link.eap.domain.eap.bean.SsidOverride;
import com.tp_link.eap.domain.eapsetting.ClientControl;
import com.tp_link.eap.domain.globalsetting.PortalSetting;
import com.tp_link.eap.domain.globalsetting.Ssid;
import com.tp_link.eap.domain.hotspot.LocalUser;
import com.tp_link.eap.domain.portal.AuthInfo;
import com.tp_link.eap.domain.portal.FacebookAuthingData;
import com.tp_link.eap.domain.portal.Guest;
import com.tp_link.eap.domain.sms.SmsToken;
import com.tp_link.eap.monitor.c.h;
import com.tp_link.eap.monitor.globalsetting.repo.SsidRepository;
import com.tp_link.eap.monitor.globalsetting.service.l;
import com.tp_link.eap.monitor.hotspot.service.LocalUserServiceI;
import com.tp_link.eap.monitor.hotspot.service.VoucherServiceI;
import com.tp_link.eap.monitor.monitor.a.e;
import com.tp_link.eap.monitor.monitor.repo.ApRepository;
import com.tp_link.eap.monitor.monitor.service.d;
import com.tp_link.eap.monitor.monitor.service.impl.ApService;
import com.tp_link.eap.monitor.portal.service.a;
import com.tp_link.eap.monitor.portal.service.b;
import com.tp_link.eap.monitor.portal.service.c;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import java.util.List;
import java.util.Locale;
import net.sf.json.JSONObject;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="authService")
public class AuthService
implements a {
    @Autowired
    private b a;
    @Autowired
    private ApService b;
    @Autowired
    private ApRepository c;
    @Autowired
    private d d;
    @Autowired
    private VoucherServiceI e;
    @Autowired
    private LocalUserServiceI f;
    @Autowired
    private c g;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.d h;
    @Autowired
    private l i;
    @Autowired
    private SsidRepository j;
    @Autowired
    private com.tp_link.eap.monitor.cloud.clouduser.service.a k;
    private final Logger l = LoggerFactory.getLogger(this.getClass());
    private static final com.tp_link.eap.monitor.monitor.a.c m = com.tp_link.eap.monitor.monitor.a.e.b();

    @Override
    public OperationResponse auth(AuthInfo info) {
        Ssid ssid = this.getSsidObjectWithOverride(info.getAp(), info.getSsid(), info.getrId());
        PortalSetting portalSetting = this.h.getPortalSetting(ssid.getPortalId());
        if (com.tp_link.eap.a.b.a((String)portalSetting.getAuthType()) != info.getAuthType()) {
            this.l.warn("Invalid Auth Type.");
            return new OperationResponse(ResErrorCode.bK);
        }
        Long l2 = System.currentTimeMillis() / 1000L;
        switch (info.getAuthType()) {
            case 0: {
                return this.addAuthInfo(info, l2 + portalSetting.getAuthDuration());
            }
            case 1: {
                if (portalSetting.getPassword().equals(info.getSimplePassword())) {
                    return this.addAuthInfo(info, l2 + portalSetting.getAuthDuration());
                }
                return new OperationResponse(ResErrorCode.cb);
            }
            case 3: {
                return this.a(info);
            }
            case 6: {
                return this.b(info);
            }
            case 7: {
                return this.c(info);
            }
            case 5: {
                return this.d(info);
            }
        }
        this.l.warn("Invalid Auth Type.");
        return new OperationResponse(ResErrorCode.bK);
    }

    @Override
    public OperationResponse unAuth(String clientId) {
        Client client = this.d.getClient(clientId);
        if (client == null) {
            this.l.warn("UnAuth client not found by clientId : " + clientId);
            return new OperationResponse(ResErrorCode.cR);
        }
        OperationResponse operationResponse = this.a.unAuthorize(client);
        if (operationResponse.success()) {
            ClientControl clientControl = new ClientControl();
            clientControl.setClientMac(client.getMac());
            clientControl.setSsid(client.getSsid());
            clientControl.setRadioId(client.getRadioId());
            clientControl.setOperation(Integer.valueOf(3));
            this.d.sendClientOperation(clientControl, null);
            this.d.reconnect(client.getMac());
        } else {
            this.l.warn("unAuth client Fail: {} ", (Object)client.toString());
        }
        return operationResponse;
    }

    @Override
    public OperationResponse unAuthNonExistClient(FacebookAuthingData authingData) {
        if (authingData == null) {
            this.l.warn("Invalid input: authingData is null");
            return com.tp_link.eap.util.e.aZ;
        }
        ClientControl clientControl = new ClientControl();
        clientControl.setClientMac(authingData.getClientMac());
        clientControl.setSsid(authingData.getSsid());
        clientControl.setRadioId(authingData.getRid());
        clientControl.setOperation(Integer.valueOf(3));
        this.d.sendClientOperation(clientControl, null);
        Ap ap = this.b.getApByMac(authingData.getAp());
        if (ap != null) {
            if (ap.getSite().equals(authingData.getSite())) {
                this.d.reconnect(authingData.getClientMac(), authingData.getAp());
            } else {
                this.l.debug("site of ap {} had been changed", (Object)ap.getMac());
            }
        } else {
            this.l.debug("Ap {} not exist now", (Object)authingData.getAp());
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse disconnect(String guestId) {
        Guest guest = this.a.findById(guestId);
        if (guest == null) {
            this.l.debug("disconnect guest not found by id:" + guestId);
            return com.tp_link.eap.util.e.aZ;
        }
        if (!guest.getIsValid().booleanValue()) {
            this.l.debug("disconnect guest is invalid guest:" + guest.toString());
            return com.tp_link.eap.util.e.bd;
        }
        boolean bl = this.a.unAuthorize(guestId);
        if (bl) {
            this.a(guest);
            String string = guest.getClientMac();
            if (string != null && string.contains(":")) {
                string = string.toUpperCase(Locale.ROOT).replace(':', '-');
            }
            this.d.reconnect(string);
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse kickoutHotspotGuest(Guest guest) {
        if (guest == null) {
            this.l.warn("AuthService kickoutHotspotGuest guest is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        OperationResponse operationResponse = this.a.kickOutHotspotGuest(guest.getId());
        if (operationResponse.success()) {
            this.a(guest);
        }
        return operationResponse;
    }

    private OperationResponse a(AuthInfo authInfo) {
        return this.e.handleAuthHotspot(authInfo);
    }

    private OperationResponse b(AuthInfo authInfo) {
        return this.g.handleAuth(authInfo);
    }

    private OperationResponse c(AuthInfo authInfo) {
        return null;
    }

    private OperationResponse d(AuthInfo authInfo) {
        return this.f.handleLocalUserAuth(authInfo);
    }

    private void a(Guest guest) {
        ClientControl clientControl = new ClientControl();
        clientControl.setClientMac(guest.getClientMac());
        clientControl.setSsid(guest.getSsidName());
        clientControl.setRadioId(guest.getRadioId());
        clientControl.setOperation(Integer.valueOf(3));
        this.d.sendClientOperation(clientControl, null);
    }

    @Override
    public OperationResponse addAuthInfo(AuthInfo info, Long endTime) {
        Object object;
        String string = com.tp_link.eap.d.b.a();
        if (string == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        Guest guest = new Guest();
        Ap ap = this.b.getApDetail(info.getAp());
        if (ap == null) {
            this.l.debug("Qeury Info Error: no Ap existed with MAC: " + info.getAp());
            return new OperationResponse(ResErrorCode.bQ);
        }
        String string2 = info.getrId() == 0 ? ap.getWlanGroupId2G() : ap.getWlanGroupId5G();
        String string3 = info.getrId() == 0 ? ap.getWlan2g() : ap.getWlan5g();
        Ssid ssid = this.i.getSsidByName(info.getSsid(), string2, info.getrId());
        Integer n2 = -1;
        if (ssid == null) {
            n2 = this.getOverridedSsidId(ap, info.getSsid(), info.getrId());
            if (n2 <= 0) {
                this.l.warn("Failed ot find ssid");
                return new OperationResponse(ResErrorCode.bQ);
            }
            ssid = this.i.getSsid(n2);
            guest.setApMac(info.getAp());
        } else {
            if (!ssid.portalIdExist().booleanValue()) {
                return new OperationResponse(ResErrorCode.bQ);
            }
            n2 = ssid.getIdInt();
            guest.setApMac(null);
        }
        guest.setAuthType(info.getAuthType());
        if (info.getAuthType() == 0) {
            object = this.h.getPortalSetting(ssid.getPortalId());
            if (object == null) {
                return new OperationResponse(ResErrorCode.bQ);
            }
            if (object.getDailyLimitEnable().booleanValue()) {
                List<Ssid> list = this.j.findByPortalId(ssid.getPortalId());
                List<Guest> list2 = this.a.getGuestList(info.getAuthType(), info.getCid());
                if (list != null && list2 != null && list.size() > 0 && list2.size() > 0) {
                    for (Ssid ssid2 : list) {
                        for (Guest guest2 : list2) {
                            if (!ssid2.getIdInt().equals(guest2.getSsidId()) || guest2.getStart() < com.tp_link.eap.monitor.c.h.a() || guest2.getStart() > com.tp_link.eap.monitor.c.h.b()) continue;
                            return new OperationResponse(ResErrorCode.bR);
                        }
                    }
                }
            }
        } else if (info.getAuthType() == 3) {
            guest.setVoucherCode(info.getVoucherCode());
            guest.setVoucher(this.e.getVoucherByCode(info.getVoucherCode()));
        } else if (info.getAuthType() == 5) {
            object = this.f.getUserByUserNameAndSite(info.getUsername(), string);
            if (object == null) {
                return new OperationResponse(ResErrorCode.bQ);
            }
            guest.setLocalUserId(object.getId());
            guest.setLocalUser((LocalUser)object);
        } else if (info.getAuthType() == 6) {
            object = this.g.getSmsTokenByPhoneNumberAndSiteAndSsidId(info.getPhoneNumber(), string, n2);
            guest.setPhoneNumber(info.getPhoneNumber());
            guest.setSmsToken((SmsToken)object);
        }
        guest.setClientMac(info.getCid());
        guest.setIsValid(Boolean.valueOf(true));
        guest.setRadioId(info.getrId());
        guest.setSsidName(info.getSsid());
        guest.setSsidId(n2);
        object = System.currentTimeMillis() / 1000L;
        guest.setStart((Long)object);
        guest.setEnd(endTime);
        guest.setSite(string);
        guest.setWlanId(string2);
        guest.setWlanName(string3);
        return this.a.addGuestInfo(guest, info.getAp());
    }

    @Override
    public Integer getOverridedSsidId(Ap ap, String ssidName, Integer radioId) {
        if (ap == null) {
            this.l.debug("Qeury Info Error: no Ap existed with MAC:");
            return -1;
        }
        List list = null;
        String string = null;
        if (radioId == 0) {
            list = ap.getSsidOverrides();
            string = ap.getWlanGroupId2G();
        } else {
            list = ap.getSsidOverrides5g();
            string = ap.getWlanGroupId5G();
        }
        if (list == null) {
            return 0;
        }
        for (SsidOverride ssidOverride : list) {
            if (!ssidName.equals(ssidOverride.getSsid())) continue;
            Ssid ssid = this.i.getSsidByName(ssidOverride.getGlobalSsid(), string, radioId);
            if (ssid == null) {
                return -1;
            }
            if (!ssid.portalIdExist().booleanValue()) {
                return -1;
            }
            return ssid.getIdInt();
        }
        return 0;
    }

    @Override
    public Ssid getSsidObjectWithOverride(String apMac, String ssid, Integer radioId) {
        Ap ap = this.c.findByMac(apMac);
        int n2 = this.getOverridedSsidId(ap, ssid, radioId);
        Ssid ssid2 = null;
        if (n2 > 0) {
            ssid2 = this.j.findByIdInt(n2);
        } else {
            String string = com.tp_link.eap.d.b.a();
            if (string != null) {
                ssid2 = this.j.findByNameAndSite(ssid, string);
            }
        }
        return ssid2;
    }

    @Override
    public OperationResponse disconnectHotSpotGuest(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("guestId", null);
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        OperationResponse operationResponse = this.disconnect(string);
        if (operationResponse.success()) {
            Guest guest = this.a.findById(string);
            String string2 = null;
            String string3 = null;
            if (controlType.equals((Object)ControlType.c) || controlType.equals((Object)ControlType.a)) {
                string2 = SecurityUtils.getSubject().hasRole("administrator") ? "Admin" : "Operator";
                string3 = (String)SecurityUtils.getSubject().getPrincipal();
            } else {
                String string4 = com.tp_link.eap.monitor.cloud.e.a.a(reqObj);
                if (com.tp_link.eap.util.a.e.a((String)string4)) {
                    this.l.warn("Failed to find accountId for cloud extendAuthDuration");
                    return com.tp_link.eap.util.e.aY;
                }
                CloudUser cloudUser = this.k.getCloudUserByAccountId(string4);
                if (cloudUser == null) {
                    return new OperationResponse(ResErrorCode.ct);
                }
                string3 = cloudUser.getAccountName();
                string2 = cloudUser.getRole().getName().equals("administrator") ? "Admin" : "Operator";
            }
            m.b("GT", "UnAuth", String.format("Guest[%s] was disconnected by %s[%s]", guest.getClientMac(), string2, string3));
        }
        return operationResponse;
    }
}

